/* ============ */
/* setrun.c	*/
/* ============ */
#include <defcodes.h>
#include <rundefs.h>
#include <math.h>
#include <mconf.h>
#include <miscdefs.h>

#define	ACT(X)	#X

#define	CLAMP(Out, Var, Lo, Hi)	Out = __min(Hi, __max(Lo, Var))

#define	EXPECT_LABEL	"Expected No. Events for Each Category"

#define	NEED_ALL(Label)	"Enter "Label

#define	NEED_USER_ENTRY(LABEL, LO, HI) \
	NEED_ALL(LABEL" ["ACT(LO)"-"ACT(HI)"]: ")

#define	REPORT_USER_INT_ENTRY(Entry, Label)		\
    {							\
	fflush(NULL); printf("\n");			\
	printf("\tNumber Entered: %.f", (double)Entry);	\
	printf(" (%s)\n", Label);			\
    }
#define	SHOW_INT_VALUE_USED(Entered, Used) 			\
	printf("\tTest Value Used: %.f%s\n", (double)Used,	\
	((double)Entered == (double)Used) ? "" : " (Clamped)")

/* ==================================================================== */
/* SetRunControls - Sets Control Parameters for Run Test		*/
/* ==================================================================== */
void
SetRunControls(RUN_DATA_STRU * RunData)
{
    int     MinCellExpect, NewlineCh, UserIntEntry;
    double  Mean, StdDev;

    NewlineCh = _isatty(_fileno(stdin)) ? '\r' : '\n';

    fflush(NULL); fprintf(stderr, "%c", NewlineCh);
    /* ------------------------------------------- */
    /* Get Minimum Expectation for Lowest Category */
    /* ------------------------------------------- */
    GetInt(NEED_USER_ENTRY(EXPECT_LABEL, MIN_CELL_XPCT,
		MAX_CELL_XPCT), &UserIntEntry);

    fflush(NULL); fprintf(stderr, "%c", NewlineCh);

    REPORT_USER_INT_ENTRY(UserIntEntry, EXPECT_LABEL);

    CLAMP(MinCellExpect, UserIntEntry, MIN_CELL_XPCT, MAX_CELL_XPCT);

    SHOW_INT_VALUE_USED(UserIntEntry, MinCellExpect);

    RunData->NumRand = (UINT)
	floor(0.5 + ((double)MinCellExpect/MIN_CELL_XPCT) * 10000.);

    P(printf("Minimum Number of Variates to be Generated = %u\n",
	RunData->NumRand));

    /* ------------------------------------------- */
    /* Get Estimate of Number of Variates Required */
    /* ------------------------------------------- */
    RunMeanStdDev((UINT)RAND_MAX+1U, RunData->NumRand, &Mean, &StdDev);

    /* ---------------------------------------------------- */
    /* Set MaxGenCount to Keep Generator from Getting Stuck */
    /* ---------------------------------------------------- */
    RunData->MaxGenCount = (long) (Mean + 10 * StdDev);

    RunData->TotVariates = 0;

    (printf("\nMinimum Number of Variates = %d\n", RunData->NumRand));
    (printf("Maximum Number to Satisfy  = %ld\n", RunData->MaxGenCount));
    fflush(NULL);
}
